private async Task PostToSlackAsync(string message)
{
    try
    {
        // Get the Slack-Webhook URL from the global parameters.
        var url = GetParameter("SlackWebhook_Common").ToString();

        // Create a request using an URL that can receive a post.
        var request = WebRequest.Create(url);

        // Set the Method property of the request to POST.
        request.Method = "POST";

        // Construct the JSON-body to send to the Slack-Webhook and convert it to a byte array.
        var json = "{ 'text':'" + message + "' }";
        var byteArray = Encoding.UTF8.GetBytes(json);

        // Set the ContentType property of the WebRequest.
        request.ContentType = "application/json";

        // Set the ContentLength property of the WebRequest.
        request.ContentLength = byteArray.Length;

        // Get the request stream.
        var dataStream = request.GetRequestStream();

        // Write the data to the request stream.
        dataStream.Write(byteArray, 0, byteArray.Length);

        // Close the Stream object.
        dataStream.Close();

        // Get the response.
        WebResponse response = request.GetResponse();
        var statusCode = ((HttpWebResponse)response).StatusCode;

        switch (statusCode)
        {
            case HttpStatusCode.OK:
                LogInfo("Slack-Message successfully posted!");
                break;

            default:
                throw new Exception($"Couldn't post to slack. StatusCode: {statusCode}");
        }
    }
    catch (Exception ex)
    {
        LogError(ex, "Slack-Message couldn't be posted!");
    }
}